### SYNTAXE
***DEV_declareUndefinedArray*** ( name  ; type ) : size   
***DEV_declareUndefinedArray*** ( name; type; 2d ) : size
	
| Parameter | Type    |    | Description                 |
| --------- | ------- |--- | --------------------------- |
| name      | Text    | →  | Name of the array variable  | 
| type      | Integer | →  | Type of the array           |
| 2d        | Boolean | →  | is 2D array                 |
| Result    | Integer | ← | Array size                  |
	
### DESCRIPTION
	
Declare an array if it is not defined:

* If the array is already declared, return its size.
* Otherwise, declare it with a size of 0.

This is a long-standing problem in 4D with arrays that are declared and sized by the same command.
<br>However, the array declaration is mandatory for the compiler.

This hack is particularly necessary in the case of internal databases where the table can be filled with C++ code, while the declaration in the 4D code will set its size to zero. 
	
### USAGE
	
```4d
If (False)
    ARRAY BOOLEAN(myArray; 0) // For the compileur
Else
    DEV_declareUndefinedArray("myArray"; Boolean array))
End if 
```
	or
	
```4d
If (False)
    ARRAY TEXT(myArray; 0) // For the compileur
End if 

For ($i; 1; Size of array(DEV_declareUndefinedArray("myArray"; Is text)); 1)

    //...

End for
```
